package gov.va.genisis2.dao.impl;

import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2.dao.IRefreshHistoryDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.RefreshHistory;

import java.util.Date;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * The Class RefreshHistoryDAO.
 *
 * The RefreshHistory data access object (DAO) is an object that provides an
 * abstract interface to some type of database or other persistence mechanism.
 * By mapping application calls to the persistence layer, RefreshHistory DAO
 * provide some specific data operations without exposing details of the
 * database.
 */
@Repository
@Transactional(value = "transactionManager")
public class RefreshHistoryDao extends AbstactHibernateDao implements IRefreshHistoryDao {
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(RefreshHistoryDao.class);
	@Autowired
	private SessionFactory sessionFactory;
	
	@Override
	public int createUserRefreshHistory(RefreshHistory refreshHistory) throws GenisisDAOException {
		if (refreshHistory == null) {
			throw new GenisisDAOException("RefreshHistory entity is null");
		}
		int id = 0;
		try {
			Session session = sessionFactory.getCurrentSession();
			// TODO: remove - switch to use SEQUENCE
			id = getMaxRowValue(session, RefreshHistory.class, CommonEnum.ID_COLUMN.getText());
			refreshHistory.setId(id);
			id = createData(session, refreshHistory);
		} catch (Exception ex) {
			LOGGER.error("Exception occured on createRefreshHistory.", ex);
			throw new GenisisDAOException("Exception occured on createRefreshHistory.", ex);
		}
		return id;
	}

	@Override
	public RefreshHistory updateUserRefreshHistory(RefreshHistory refreshHistory) throws GenisisDAOException {
		RefreshHistory updatedRefreshHistory;
		try {
			Session session = sessionFactory.getCurrentSession();
			updatedRefreshHistory = (RefreshHistory) updateData(session, refreshHistory);
		} catch (Exception ex) {
			LOGGER.error("Exception occured on updateRefreshHistory.", ex);
			throw new GenisisDAOException("Exception occured on updateRefreshHistory.", ex);
		}
		return updatedRefreshHistory;
	}

	@Override
	public Date getLatestUserRefreshHistory() throws GenisisDAOException {
		Date lastUserRefreshed = null;
		try {
			Session session = sessionFactory.getCurrentSession();
			CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
			CriteriaQuery<Date> criteriaQuery = criteriaBuilder.createQuery(Date.class);
			Root<RefreshHistory> root = criteriaQuery.from(RefreshHistory.class);
			Predicate statusCheck = criteriaBuilder.equal(root.get(CommonEnum.STATUS.getText()), CommonEnum.STATUS_COMPLETED.getText());
			Predicate endDtNull = criteriaBuilder.isNotNull(root.get(CommonEnum.END_DATE.getText()));
			Predicate conditions = criteriaBuilder.and(statusCheck, endDtNull);
			criteriaQuery.where(conditions);
			criteriaQuery.select(criteriaBuilder.greatest(root.<Date> get(CommonEnum.END_DATE.getText())));
			lastUserRefreshed = session.createQuery(criteriaQuery).getSingleResult();
		} catch (Exception ex) {
			// LOGGER.error(ErrorEnum.USER_DAO_EXP_GETLATESTRefreshHistory.getErrorMessage(),
			// ex);
			throw new GenisisDAOException(ex.getClass().getSimpleName(), ex);
		}
		return lastUserRefreshed;
	}
}